/*
 * Decompiled with CFR 0.152.
 */
package net.peanuuutz.tomlkt.internal;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import net.peanuuutz.tomlkt.TomlElementKt;
import net.peanuuutz.tomlkt.TomlInteger;
import net.peanuuutz.tomlkt.TomlLiteral;
import net.peanuuutz.tomlkt.internal.StringUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\u001a0\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020#H\u0000\u001a(\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020#H\u0000\u001a\f\u0010.\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\u0016\u0010/\u001a\u00020\u0002*\u00020\u000b2\b\b\u0002\u00100\u001a\u00020#H\u0000\u001a\u0016\u0010/\u001a\u00020\u0002*\u00020\u00022\b\b\u0002\u00100\u001a\u00020#H\u0000\u001a\f\u00101\u001a\u00020\u0002*\u000202H\u0000\u001a\f\u00101\u001a\u00020\u0002*\u000203H\u0000\u001a\f\u00104\u001a\u00020\u0002*\u00020\u0002H\u0000\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u000e\u0010\n\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u001a\u001a\u00020\u0002*\u00020\u00028\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u0019\u0010\u001d\u001a\u00020\u0002*\u00020\u00028\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c*\u0018\b\u0000\u00105\"\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u00066"}, d2={"AsciiMapping", "", "", "getAsciiMapping", "()Ljava/util/List;", "BareKeyConstraints", "BareKeyRegex", "Lkotlin/text/Regex;", "getBareKeyRegex", "()Lkotlin/text/Regex;", "Comment", "", "DecimalConstraints", "DecimalOrSignConstraints", "DefiniteDateTimeConstraints", "DefiniteNumberConstraints", "ElementSeparator", "EndArray", "EndInlineTable", "EndTableHead", "HexadecimalConstraints", "KeySeparator", "KeyValueSeparator", "StartArray", "StartInlineTable", "StartTableHead", "doubleQuoted", "getDoubleQuoted", "(Ljava/lang/String;)Ljava/lang/String;", "singleQuoted", "getSingleQuoted", "createNumberTomlLiteral", "Lnet/peanuuutz/tomlkt/TomlLiteral;", "content", "isPositive", "", "radix", "", "isDouble", "isExponent", "processIntegerString", "raw", "base", "Lnet/peanuuutz/tomlkt/TomlInteger$Base;", "group", "uppercase", "doubleQuotedIfNotPure", "escape", "multiline", "toStringModified", "", "", "unescape", "Path", "tomlkt"})
@SourceDebugExtension(value={"SMAP\nStringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUtils.kt\nnet/peanuuutz/tomlkt/internal/StringUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n84#1:262\n1#2:263\n*S KotlinDebug\n*F\n+ 1 StringUtils.kt\nnet/peanuuutz/tomlkt/internal/StringUtilsKt\n*L\n87#1:262\n*E\n"})
public final class StringUtilsKt {
    public static final char Comment = '#';
    public static final char KeySeparator = '.';
    public static final char KeyValueSeparator = '=';
    public static final char ElementSeparator = ',';
    public static final char StartTableHead = '[';
    public static final char EndTableHead = ']';
    public static final char StartArray = '[';
    public static final char EndArray = ']';
    public static final char StartInlineTable = '{';
    public static final char EndInlineTable = '}';
    @NotNull
    public static final String DecimalConstraints = "0123456789";
    @NotNull
    public static final String HexadecimalConstraints = "0123456789abcdefABCDEF";
    @NotNull
    public static final String DecimalOrSignConstraints = "0123456789-+";
    @NotNull
    public static final String BareKeyConstraints = "abcdefghijklmnopqrstuvwxyz-_ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    @NotNull
    public static final String DefiniteDateTimeConstraints = "Tt:Zz";
    @NotNull
    public static final String DefiniteNumberConstraints = ".acdefABCDEF_";
    @NotNull
    private static final Regex BareKeyRegex;
    @NotNull
    private static final List<String> AsciiMapping;

    @NotNull
    public static final Regex getBareKeyRegex() {
        return BareKeyRegex;
    }

    @NotNull
    public static final List<String> getAsciiMapping() {
        return AsciiMapping;
    }

    @NotNull
    public static final String getSingleQuoted(@NotNull String $this$singleQuoted) {
        Intrinsics.checkNotNullParameter((Object)$this$singleQuoted, (String)"<this>");
        boolean $i$f$getSingleQuoted = false;
        return '\'' + $this$singleQuoted + '\'';
    }

    @NotNull
    public static final String getDoubleQuoted(@NotNull String $this$doubleQuoted) {
        Intrinsics.checkNotNullParameter((Object)$this$doubleQuoted, (String)"<this>");
        boolean $i$f$getDoubleQuoted = false;
        return '\"' + $this$doubleQuoted + '\"';
    }

    @NotNull
    public static final String doubleQuotedIfNotPure(@NotNull String $this$doubleQuotedIfNotPure) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$doubleQuotedIfNotPure, (String)"<this>");
        if (BareKeyRegex.matches((CharSequence)$this$doubleQuotedIfNotPure)) {
            string = $this$doubleQuotedIfNotPure;
        } else {
            String $this$doubleQuoted$iv = $this$doubleQuotedIfNotPure;
            boolean $i$f$getDoubleQuoted = false;
            string = '\"' + $this$doubleQuoted$iv + '\"';
        }
        return string;
    }

    @NotNull
    public static final String escape(char $this$escape, boolean multiline) {
        return $this$escape >= '\u0080' ? String.valueOf($this$escape) : (!multiline ? AsciiMapping.get($this$escape) : ($this$escape == '\\' ? "\\\\" : ($this$escape == '\t' ? "\t" : ($this$escape == '\n' ? "\n" : ($this$escape == '\r' ? "\r" : AsciiMapping.get($this$escape))))));
    }

    public static /* synthetic */ String escape$default(char c, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return StringUtilsKt.escape(c, bl);
    }

    @NotNull
    public static final String escape(@NotNull String $this$escape, boolean multiline) {
        Intrinsics.checkNotNullParameter((Object)$this$escape, (String)"<this>");
        StringBuilder builder = new StringBuilder();
        int n = $this$escape.length();
        for (int i = 0; i < n; ++i) {
            char c = $this$escape.charAt(i);
            builder.append(StringUtilsKt.escape(c, multiline));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String escape$default(String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return StringUtilsKt.escape(string, bl);
    }

    @NotNull
    public static final String unescape(@NotNull String $this$unescape) {
        Intrinsics.checkNotNullParameter((Object)$this$unescape, (String)"<this>");
        if (StringsKt.isBlank((CharSequence)$this$unescape)) {
            return $this$unescape;
        }
        StringBuilder builder = new StringBuilder();
        int lastIndex = StringsKt.getLastIndex((CharSequence)$this$unescape);
        int i = 0;
        while (i <= lastIndex) {
            char c;
            char current = $this$unescape.charAt(i);
            if (current != '\\') {
                builder.append(current);
                ++i;
                continue;
            }
            if (!(i != lastIndex)) {
                boolean $i$a$-require-StringUtilsKt$unescape$42 = false;
                String $i$a$-require-StringUtilsKt$unescape$42 = "Unexpected end in " + $this$unescape;
                throw new IllegalArgumentException($i$a$-require-StringUtilsKt$unescape$42.toString());
            }
            char next = $this$unescape.charAt(i + 1);
            if (next == 'n') {
                builder.append('\n');
                ++i;
            } else if (next == '\"') {
                builder.append('\"');
                ++i;
            } else if (next == '\\') {
                builder.append('\\');
                ++i;
            } else if (next == 'u') {
                if (!(lastIndex >= i + 5)) {
                    boolean $i$a$-require-StringUtilsKt$unescape$52 = false;
                    String $i$a$-require-StringUtilsKt$unescape$52 = "Unexpected end in " + $this$unescape;
                    throw new IllegalArgumentException($i$a$-require-StringUtilsKt$unescape$52.toString());
                }
                String string = $this$unescape.substring(i + 2, i + 6);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                c = (char)Integer.parseInt(string, CharsKt.checkRadix((int)16));
                builder.append(c);
                i += 5;
            } else if (next == 'U') {
                if (!(lastIndex >= i + 9)) {
                    boolean bl = false;
                    String string = "Unexpected end in " + $this$unescape;
                    throw new IllegalArgumentException(string.toString());
                }
                String string = $this$unescape.substring(i + 2, i + 10);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                c = (char)Integer.parseInt(string, CharsKt.checkRadix((int)16));
                builder.append(c);
                i += 9;
            } else if (next == 't') {
                builder.append('\t');
                ++i;
            } else if (next == 'r') {
                builder.append('\r');
                ++i;
            } else if (next == 'b') {
                builder.append('\b');
                ++i;
            } else if (next == 'f') {
                builder.append('\f');
                ++i;
            } else {
                throw new IllegalStateException(("Unknown escape " + next).toString());
            }
            ++i;
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String toStringModified(float $this$toStringModified) {
        return Float.isNaN($this$toStringModified) ? "nan" : (Float.isInfinite($this$toStringModified) ? ($this$toStringModified > 0.0f ? "inf" : "-inf") : String.valueOf($this$toStringModified));
    }

    @NotNull
    public static final String toStringModified(double $this$toStringModified) {
        return Double.isNaN($this$toStringModified) ? "nan" : (Double.isInfinite($this$toStringModified) ? ($this$toStringModified > 0.0 ? "inf" : "-inf") : String.valueOf($this$toStringModified));
    }

    @NotNull
    public static final String processIntegerString(@NotNull String raw, @NotNull TomlInteger.Base base, int group, boolean uppercase) {
        String string;
        String string2;
        boolean isNegative;
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter((Object)((Object)base), (String)"base");
        boolean bl = isNegative = raw.charAt(0) == '-';
        if (!isNegative) {
            string2 = raw;
        } else {
            String string3 = raw.substring(1);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        }
        String digits = string2;
        if (base.compareTo((Enum)TomlInteger.Base.Dec) <= 0 || !uppercase) {
            string = digits;
        } else {
            String string4 = digits.toUpperCase(Locale.ROOT);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        }
        String upper = string;
        String grouped2 = group == 0 ? upper : CollectionsKt.joinToString$default((Iterable)CollectionsKt.asReversed((List)StringsKt.chunked((CharSequence)((Object)StringsKt.reversed((CharSequence)upper)).toString(), (int)group, (Function1)processIntegerString.grouped.1.INSTANCE)), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null);
        String result = !isNegative ? base.getPrefix() + grouped2 : '-' + base.getPrefix() + grouped2;
        return result;
    }

    @NotNull
    public static final TomlLiteral createNumberTomlLiteral(@NotNull String content, boolean isPositive, int radix, boolean isDouble, boolean isExponent) {
        long l;
        long factor;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (isDouble) {
            double d;
            double factor2;
            double d2 = factor2 = isPositive ? 1.0 : -1.0;
            if (isExponent) {
                char[] cArray = new char[]{'e'};
                List strings = StringsKt.split$default((CharSequence)content, (char[])cArray, (boolean)true, (int)0, (int)4, null);
                d = Double.parseDouble((String)strings.get(0)) * (factor2 *= Math.pow(10.0, Integer.parseInt((String)strings.get(1))));
            } else {
                d = Double.parseDouble(content) * factor2;
            }
            double d3 = d;
            return TomlElementKt.TomlLiteral(d3);
        }
        long l2 = factor = isPositive ? 1L : -1L;
        if (isExponent) {
            char[] cArray = new char[]{'e'};
            List strings = StringsKt.split$default((CharSequence)content, (char[])cArray, (boolean)true, (int)0, (int)4, null);
            l = Long.parseLong((String)strings.get(0), CharsKt.checkRadix((int)radix)) * (factor *= (long)Math.pow(10.0, Integer.parseInt((String)strings.get(1))));
        } else {
            Long l3 = StringsKt.toLongOrNull((String)content, (int)radix);
            if (l3 == null) {
                if (!isPositive) {
                    boolean bl = false;
                    String string = "ULong cannot be negative";
                    throw new IllegalArgumentException(string.toString());
                }
                return TomlElementKt.TomlLiteral-VKZWuLQ(UStringsKt.toULong((String)content, (int)radix));
            }
            l = l3 * factor;
        }
        long l4 = l;
        return TomlElementKt.TomlLiteral(l4);
    }

    static {
        int i;
        List list;
        BareKeyRegex = new Regex("[A-Za-z0-9_-]+");
        List $this$AsciiMapping_u24lambda_u240 = list = CollectionsKt.createListBuilder((int)128);
        boolean bl = false;
        for (i = 0; i < 16; ++i) {
            $this$AsciiMapping_u24lambda_u240.add(i, "\\u000" + i);
        }
        for (i = 16; i < 32; ++i) {
            $this$AsciiMapping_u24lambda_u240.add(i, "\\u00" + i);
        }
        for (i = 32; i < 128; ++i) {
            $this$AsciiMapping_u24lambda_u240.add(i, String.valueOf((char)i));
        }
        $this$AsciiMapping_u24lambda_u240.set(8, "\\b");
        $this$AsciiMapping_u24lambda_u240.set(9, "\\t");
        $this$AsciiMapping_u24lambda_u240.set(10, "\\n");
        $this$AsciiMapping_u24lambda_u240.set(12, "\\f");
        $this$AsciiMapping_u24lambda_u240.set(13, "\\r");
        $this$AsciiMapping_u24lambda_u240.set(34, "\\\"");
        $this$AsciiMapping_u24lambda_u240.set(92, "\\\\");
        AsciiMapping = CollectionsKt.build((List)list);
    }
}

